/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.Register;
import io.github.mortuusars.exposure.advancements.predicate.FramePredicate;
import io.github.mortuusars.exposure.advancements.trigger.FrameExposedTrigger;
import io.github.mortuusars.exposure.advancements.trigger.FramePrintedTrigger;
import io.github.mortuusars.exposure.commands.argument.ColorPaletteArgument;
import io.github.mortuusars.exposure.commands.argument.ExposureLookArgument;
import io.github.mortuusars.exposure.commands.argument.ShaderLocationArgument;
import io.github.mortuusars.exposure.commands.argument.SizeMultiplierArgument;
import io.github.mortuusars.exposure.commands.argument.TextureLocationArgument;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.data.Filter;
import io.github.mortuusars.exposure.data.Lens;
import io.github.mortuusars.exposure.world.block.FlashBlock;
import io.github.mortuusars.exposure.world.block.LightroomBlock;
import io.github.mortuusars.exposure.world.block.entity.LightroomBlockEntity;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.ProjectionMode;
import io.github.mortuusars.exposure.world.camera.component.CompositionGuide;
import io.github.mortuusars.exposure.world.camera.component.FlashMode;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.entity.GlassPhotographFrameEntity;
import io.github.mortuusars.exposure.world.entity.PhotographFrameEntity;
import io.github.mortuusars.exposure.world.inventory.AlbumMenu;
import io.github.mortuusars.exposure.world.inventory.CameraAttachmentsMenu;
import io.github.mortuusars.exposure.world.inventory.ItemRenameMenu;
import io.github.mortuusars.exposure.world.inventory.LecternAlbumMenu;
import io.github.mortuusars.exposure.world.inventory.LightroomMenu;
import io.github.mortuusars.exposure.world.inventory.SignedAlbumMenu;
import io.github.mortuusars.exposure.world.item.AgedPhotographItem;
import io.github.mortuusars.exposure.world.item.AlbumItem;
import io.github.mortuusars.exposure.world.item.BrokenInterplanarProjectorItem;
import io.github.mortuusars.exposure.world.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.world.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.world.item.FilmRollItem;
import io.github.mortuusars.exposure.world.item.GlassPhotographFrameItem;
import io.github.mortuusars.exposure.world.item.InterplanarProjectorItem;
import io.github.mortuusars.exposure.world.item.PhotographFrameItem;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.SignedAlbumItem;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import io.github.mortuusars.exposure.world.item.camera.Shutter;
import io.github.mortuusars.exposure.world.item.camera.ShutterState;
import io.github.mortuusars.exposure.world.item.component.StoredItemStack;
import io.github.mortuusars.exposure.world.item.component.album.AlbumContent;
import io.github.mortuusars.exposure.world.item.component.album.SignedAlbumContent;
import io.github.mortuusars.exposure.world.item.crafting.recipe.ComponentTransferringRecipe;
import io.github.mortuusars.exposure.world.item.crafting.recipe.FilmDevelopingRecipe;
import io.github.mortuusars.exposure.world.item.crafting.recipe.PhotographAgingRecipe;
import io.github.mortuusars.exposure.world.item.crafting.recipe.PhotographCopyingRecipe;
import io.github.mortuusars.exposure.world.item.crafting.recipe.serializer.ComponentTransferringRecipeSerializer;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1865;
import net.minecraft.class_2135;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3446;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_3917;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9331;
import net.minecraft.class_9360;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Exposure {
    public static final String ID = "exposure";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final List<String> MODS_REQUIRING_DIRECT_CAPTURE = List.of("iris", "oculus", "effective", "distanthorizons");
    public static final int MAX_ENTITIES_IN_FRAME = 10;

    public static void init() {
        Blocks.init();
        BlockEntityTypes.init();
        EntityTypes.init();
        Items.init();
        DataComponents.init();
        CriteriaTriggers.init();
        ItemSubPredicates.init();
        MenuTypes.init();
        RecipeSerializers.init();
        SoundEvents.init();
        ArgumentTypes.init();
    }

    public static void initServer(MinecraftServer server) {
        ExposureServer.init(server);
    }

    public static class_2960 resource(String path) {
        return class_2960.method_60655((String)ID, (String)path);
    }

    public static class Blocks {
        public static final Supplier<LightroomBlock> LIGHTROOM = Register.block("lightroom", () -> new LightroomBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_15977).method_9632(2.5f).method_9626(class_2498.field_11547)));
        public static final Supplier<FlashBlock> FLASH = Register.block("flash", () -> new FlashBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10124).method_9629(-1.0f, 3600000.8f).method_42327().method_31710(class_3620.field_16008).method_22488().method_9634().method_9631(state -> 15)));

        static void init() {
        }
    }

    public static class BlockEntityTypes {
        public static final Supplier<class_2591<LightroomBlockEntity>> LIGHTROOM = Register.blockEntityType("lightroom", () -> Register.newBlockEntityType(LightroomBlockEntity::new, Blocks.LIGHTROOM.get()));

        static void init() {
        }
    }

    public static class EntityTypes {
        public static final Supplier<class_1299<PhotographFrameEntity>> PHOTOGRAPH_FRAME = Register.entityType("photograph_frame", PhotographFrameEntity::new, class_1311.field_17715, false, builder -> builder.method_17687(0.5f, 0.5f).method_27299(128).method_27300(Integer.MAX_VALUE).method_55687(0.0f));
        public static final Supplier<class_1299<GlassPhotographFrameEntity>> CLEAR_PHOTOGRAPH_FRAME = Register.entityType("glass_photograph_frame", GlassPhotographFrameEntity::new, class_1311.field_17715, false, builder -> builder.method_17687(0.5f, 0.5f).method_27299(128).method_27300(Integer.MAX_VALUE).method_55687(0.0f));

        static void init() {
        }
    }

    public static class Items {
        public static final Supplier<CameraItem> CAMERA = Register.item("camera", () -> new CameraItem(new Shutter(), new class_1792.class_1793().method_7889(1).method_57349(DataComponents.CAMERA_ACTIVE, (Object)false)));
        public static final Supplier<FilmRollItem> BLACK_AND_WHITE_FILM = Register.item("black_and_white_film", () -> new FilmRollItem(ExposureType.BLACK_AND_WHITE, class_3532.method_15353((float)0.8f, (float)0.8f, (float)0.9f), new class_1792.class_1793().method_7889(16)));
        public static final Supplier<FilmRollItem> COLOR_FILM = Register.item("color_film", () -> new FilmRollItem(ExposureType.COLOR, class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f), new class_1792.class_1793().method_7889(16)));
        public static final Supplier<DevelopedFilmItem> DEVELOPED_BLACK_AND_WHITE_FILM = Register.item("developed_black_and_white_film", () -> new DevelopedFilmItem(ExposureType.BLACK_AND_WHITE, new class_1792.class_1793().method_7889(1)));
        public static final Supplier<DevelopedFilmItem> DEVELOPED_COLOR_FILM = Register.item("developed_color_film", () -> new DevelopedFilmItem(ExposureType.COLOR, new class_1792.class_1793().method_7889(1)));
        public static final Supplier<PhotographItem> PHOTOGRAPH = Register.item("photograph", () -> new PhotographItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<ChromaticSheetItem> CHROMATIC_SHEET = Register.item("chromatic_sheet", () -> new ChromaticSheetItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<PhotographItem> AGED_PHOTOGRAPH = Register.item("aged_photograph", () -> new AgedPhotographItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<InterplanarProjectorItem> INTERPLANAR_PROJECTOR = Register.item("interplanar_projector", () -> new InterplanarProjectorItem(new class_1792.class_1793()));
        public static final Supplier<BrokenInterplanarProjectorItem> BROKEN_INTERPLANAR_PROJECTOR = Register.item("broken_interplanar_projector", () -> new BrokenInterplanarProjectorItem(new class_1792.class_1793()));
        public static final Supplier<StackedPhotographsItem> STACKED_PHOTOGRAPHS = Register.item("stacked_photographs", () -> new StackedPhotographsItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<AlbumItem> ALBUM = Register.item("album", () -> new AlbumItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<SignedAlbumItem> SIGNED_ALBUM = Register.item("signed_album", () -> new SignedAlbumItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<PhotographFrameItem> PHOTOGRAPH_FRAME = Register.item("photograph_frame", () -> new PhotographFrameItem(new class_1792.class_1793()));
        public static final Supplier<GlassPhotographFrameItem> CLEAR_PHOTOGRAPH_FRAME = Register.item("glass_photograph_frame", () -> new GlassPhotographFrameItem(new class_1792.class_1793()));
        public static final Supplier<class_1747> LIGHTROOM = Register.item("lightroom", () -> new class_1747((class_2248)Blocks.LIGHTROOM.get(), new class_1792.class_1793()));

        static void init() {
        }
    }

    public static class DataComponents {
        public static final class_9331<CameraId> CAMERA_ID = Register.dataComponentType("camera_id", arg -> arg.method_57881(CameraId.CODEC).method_57882(CameraId.STREAM_CODEC));
        public static final class_9331<Boolean> CAMERA_ACTIVE = Register.dataComponentType("camera_active", arg -> arg.method_57881((Codec)Codec.BOOL).method_57882(class_9135.field_48547));
        public static final class_9331<Boolean> CAMERA_DISASSEMBLED = Register.dataComponentType("camera_disassembled", arg -> arg.method_57881((Codec)Codec.BOOL).method_57882(class_9135.field_48547));
        public static final class_9331<Long> CAMERA_LAST_ACTION_TIME = Register.dataComponentType("camera_last_action_time", arg -> arg.method_57881((Codec)Codec.LONG).method_57882(class_9135.field_48551));
        public static final class_9331<Boolean> SELFIE_MODE = Register.dataComponentType("camera_selfie_mode", arg -> arg.method_57881((Codec)Codec.BOOL).method_57882(class_9135.field_48547));
        public static final class_9331<ShutterState> SHUTTER_STATE = Register.dataComponentType("camera_shutter_state", arg -> arg.method_57881(ShutterState.CODEC).method_57882(ShutterState.STREAM_CODEC));
        public static final class_9331<ShutterSpeed> SHUTTER_SPEED = Register.dataComponentType("camera_shutter_speed", arg -> arg.method_57881(ShutterSpeed.CODEC).method_57882(ShutterSpeed.STREAM_CODEC));
        public static final class_9331<CompositionGuide> COMPOSITION_GUIDE = Register.dataComponentType("camera_composition_guide", arg -> arg.method_57881(CompositionGuide.CODEC).method_57882(CompositionGuide.STREAM_CODEC));
        public static final class_9331<Float> ZOOM = Register.dataComponentType("camera_zoom", arg -> arg.method_57881((Codec)Codec.FLOAT).method_57882(class_9135.field_48552));
        public static final class_9331<Double> SELFIE_ROTATION_X = Register.dataComponentType("camera_selfie_rotation_x", arg -> arg.method_57881((Codec)Codec.DOUBLE).method_57882(class_9135.field_48553));
        public static final class_9331<Double> SELFIE_ROTATION_Y = Register.dataComponentType("camera_selfie_rotation_y", arg -> arg.method_57881((Codec)Codec.DOUBLE).method_57882(class_9135.field_48553));
        public static final class_9331<FlashMode> FLASH_MODE = Register.dataComponentType("camera_flash_mode", arg -> arg.method_57881(FlashMode.CODEC).method_57882(FlashMode.STREAM_CODEC));
        public static final class_9331<StoredItemStack> FILM = Register.dataComponentType("camera_film", arg -> arg.method_57881(StoredItemStack.CODEC).method_57882(StoredItemStack.STREAM_CODEC));
        public static final class_9331<StoredItemStack> FLASH = Register.dataComponentType("camera_flash", arg -> arg.method_57881(StoredItemStack.CODEC).method_57882(StoredItemStack.STREAM_CODEC));
        public static final class_9331<StoredItemStack> LENS = Register.dataComponentType("camera_lens", arg -> arg.method_57881(StoredItemStack.CODEC).method_57882(StoredItemStack.STREAM_CODEC));
        public static final class_9331<StoredItemStack> FILTER = Register.dataComponentType("camera_filter", arg -> arg.method_57881(StoredItemStack.CODEC).method_57882(StoredItemStack.STREAM_CODEC));
        public static final class_9331<class_2960> FILM_COLOR_PALETTE = Register.dataComponentType("film_color_palette", arg -> arg.method_57881(class_2960.field_25139).method_57882(class_2960.field_48267));
        public static final class_9331<Integer> FILM_FRAME_COUNT = Register.dataComponentType("film_frame_count", arg -> arg.method_57881(class_5699.method_48766((int)1, (int)256)).method_57882(class_9135.field_48550));
        public static final class_9331<Integer> FILM_FRAME_SIZE = Register.dataComponentType("film_frame_size", arg -> arg.method_57881(class_5699.method_48766((int)1, (int)2048)).method_57882(class_9135.field_48550));
        public static final class_9331<List<Frame>> FILM_FRAMES = Register.dataComponentType("film_frames", arg -> arg.method_57881(Frame.CODEC.listOf()).method_57882(Frame.STREAM_CODEC.method_56433(class_9135.method_56363())));
        public static final class_9331<Frame> PHOTOGRAPH_FRAME = Register.dataComponentType("photograph_frame", arg -> arg.method_57881(Frame.CODEC).method_57882(Frame.STREAM_CODEC));
        public static final class_9331<ExposureType> PHOTOGRAPH_TYPE = Register.dataComponentType("photograph_type", arg -> arg.method_57881(ExposureType.CODEC).method_57882(ExposureType.STREAM_CODEC));
        public static final class_9331<Integer> PHOTOGRAPH_GENERATION = Register.dataComponentType("photograph_generation", arg -> arg.method_57881(class_5699.method_48766((int)0, (int)3)).method_57882(class_9135.field_48550));
        public static final class_9331<List<ItemAndStack<PhotographItem>>> STACKED_PHOTOGRAPHS = Register.dataComponentType("stacked_photographs", arg -> arg.method_57881(StackedPhotographsItem.PHOTOGRAPH_ITEM_AND_STACK_CODEC.listOf(0, 64)).method_57882(StackedPhotographsItem.PHOTOGRAPH_ITEM_AND_STACK_STREAM_CODEC.method_56433(class_9135.method_56363())));
        public static final class_9331<AlbumContent> ALBUM_CONTENT = Register.dataComponentType("album_content", arg -> arg.method_57881(AlbumContent.CODEC).method_57882(AlbumContent.STREAM_CODEC));
        public static final class_9331<SignedAlbumContent> SIGNED_ALBUM_CONTENT = Register.dataComponentType("signed_album_content", arg -> arg.method_57881(SignedAlbumContent.CODEC).method_57882(SignedAlbumContent.STREAM_CODEC));
        public static final class_9331<ProjectionMode> INTERPLANAR_PROJECTOR_MODE = Register.dataComponentType("interplanar_projector_mode", arg -> arg.method_57881(ProjectionMode.CODEC).method_57882(ProjectionMode.STREAM_CODEC));
        public static final class_9331<String> INTERPLANAR_PROJECTOR_ERROR_CODE = Register.dataComponentType("interplanar_projector_error_code", arg -> arg.method_57881((Codec)Codec.STRING).method_57882(class_9135.field_48554));
        public static final class_9331<List<Frame>> CHROMATIC_SHEET_LAYERS = Register.dataComponentType("chromatic_layers", arg -> arg.method_57881(Frame.CODEC.listOf(0, 3)).method_57882(Frame.STREAM_CODEC.method_56433(class_9135.method_56363())));

        static void init() {
        }
    }

    public static class CriteriaTriggers {
        public static Supplier<FrameExposedTrigger> FRAME_EXPOSED = Register.criterionTrigger("frame_exposed", FrameExposedTrigger::new);
        public static Supplier<FramePrintedTrigger> FRAME_PRINTED = Register.criterionTrigger("frame_printed", FramePrintedTrigger::new);
        public static Supplier<class_2135> PHOTOGRAPH_ENDERMAN_EYES = Register.criterionTrigger("photograph_enderman_eyes", class_2135::new);
        public static Supplier<class_2135> SUCCESSFULLY_PROJECT_IMAGE = Register.criterionTrigger("successfully_project_image", class_2135::new);

        public static void init() {
        }
    }

    public static class ItemSubPredicates {
        public static Supplier<class_9360.class_8745<FramePredicate>> FRAME = Register.itemSubPredicate("frame", () -> new class_9360.class_8745(FramePredicate.CODEC));

        public static void init() {
        }
    }

    public static class MenuTypes {
        public static final Supplier<class_3917<CameraAttachmentsMenu>> CAMERA = Register.menuType("camera", CameraAttachmentsMenu::fromBuffer);
        public static final Supplier<class_3917<AlbumMenu>> ALBUM = Register.menuType("album", AlbumMenu::fromBuffer);
        public static final Supplier<class_3917<SignedAlbumMenu>> SIGNED_ALBUM = Register.menuType("signed_album", SignedAlbumMenu::fromBuffer);
        public static final Supplier<class_3917<LecternAlbumMenu>> LECTERN_ALBUM = Register.menuType("lectern_album", LecternAlbumMenu::new);
        public static final Supplier<class_3917<LightroomMenu>> LIGHTROOM = Register.menuType("lightroom", LightroomMenu::fromBuffer);
        public static final Supplier<class_3917<ItemRenameMenu>> ITEM_RENAME = Register.menuType("item_rename", ItemRenameMenu::fromBuffer);

        static void init() {
        }
    }

    public static class RecipeSerializers {
        public static final Supplier<class_1865<?>> FILM_DEVELOPING = RecipeSerializers.registerTransferring("film_developing", "film", FilmDevelopingRecipe::new);
        public static final Supplier<class_1865<?>> PHOTOGRAPH_COPYING = RecipeSerializers.registerTransferring("photograph_copying", "photograph", PhotographCopyingRecipe::new);
        public static final Supplier<class_1865<?>> PHOTOGRAPH_AGING = RecipeSerializers.registerTransferring("photograph_aging", "photograph", PhotographAgingRecipe::new);
        public static final Supplier<class_1865<?>> COMPONENT_TRANSFERRING = RecipeSerializers.registerTransferring("component_transferring", "source", ComponentTransferringRecipe::new);

        private static <T extends ComponentTransferringRecipe> Supplier<class_1865<?>> registerTransferring(String name, String sourceName, ComponentTransferringRecipeSerializer.RecipeConstructor<T> recipeConstructor) {
            return Register.recipeSerializer(name, () -> new ComponentTransferringRecipeSerializer(name, sourceName, recipeConstructor));
        }

        static void init() {
        }
    }

    public static class SoundEvents {
        public static final Supplier<class_3414> VIEWFINDER_OPEN = SoundEvents.register("item", "camera.viewfinder_open");
        public static final Supplier<class_3414> VIEWFINDER_CLOSE = SoundEvents.register("item", "camera.viewfinder_close");
        public static final Supplier<class_3414> SHUTTER_OPEN = SoundEvents.register("item", "camera.shutter_open");
        public static final Supplier<class_3414> SHUTTER_CLOSE = SoundEvents.register("item", "camera.shutter_close");
        public static final Supplier<class_3414> SHUTTER_TICKING = SoundEvents.register("item", "camera.shutter_ticking");
        public static final Supplier<class_3414> FILM_ADVANCE = SoundEvents.register("item", "camera.film_advance");
        public static final Supplier<class_3414> FILM_ADVANCE_LAST = SoundEvents.register("item", "camera.film_advance_last");
        public static final Supplier<class_3414> FILM_REMOVED = SoundEvents.register("item", "camera.film_removed");
        public static final Supplier<class_3414> CAMERA_GENERIC_CLICK = SoundEvents.register("item", "camera.generic_click");
        public static final Supplier<class_3414> CAMERA_BUTTON_CLICK = SoundEvents.register("item", "camera.button_click");
        public static final Supplier<class_3414> CAMERA_RELEASE_BUTTON_CLICK = SoundEvents.register("item", "camera.release_button_click");
        public static final Supplier<class_3414> CAMERA_DIAL_CLICK = SoundEvents.register("item", "camera.dial_click");
        public static final Supplier<class_3414> CAMERA_LENS_RING_CLICK = SoundEvents.register("item", "camera.lens_ring_click");
        public static final Supplier<class_3414> LENS_INSERT = SoundEvents.register("item", "camera.lens_insert");
        public static final Supplier<class_3414> LENS_REMOVE = SoundEvents.register("item", "camera.lens_remove");
        public static final Supplier<class_3414> FILTER_INSERT = SoundEvents.register("item", "camera.filter_insert");
        public static final Supplier<class_3414> FILTER_REMOVE = SoundEvents.register("item", "camera.filter_remove");
        public static final Supplier<class_3414> FLASH = SoundEvents.register("item", "camera.flash");
        public static final Supplier<class_3414> INTERPLANAR_PROJECT = SoundEvents.register("item", "camera.interplanar_projector.project");
        public static final Supplier<class_3414> PHOTOGRAPH_PLACE = SoundEvents.register("item", "photograph.place");
        public static final Supplier<class_3414> PHOTOGRAPH_BREAK = SoundEvents.register("item", "photograph.break");
        public static final Supplier<class_3414> PHOTOGRAPH_RUSTLE = SoundEvents.register("item", "photograph.rustle");
        public static final Supplier<class_3414> PHOTOGRAPH_FRAME_PLACE = SoundEvents.register("item", "photograph_frame.place");
        public static final Supplier<class_3414> PHOTOGRAPH_FRAME_BREAK = SoundEvents.register("item", "photograph_frame.break");
        public static final Supplier<class_3414> PHOTOGRAPH_FRAME_ADD_ITEM = SoundEvents.register("item", "photograph_frame.add_item");
        public static final Supplier<class_3414> PHOTOGRAPH_FRAME_REMOVE_ITEM = SoundEvents.register("item", "photograph_frame.remove_item");
        public static final Supplier<class_3414> PHOTOGRAPH_FRAME_ROTATE_ITEM = SoundEvents.register("item", "photograph_frame.rotate_item");
        public static final Supplier<class_3414> LIGHTROOM_PRINT = SoundEvents.register("block", "lightroom.print");
        public static final Supplier<class_3414> WRITE = SoundEvents.register("misc", "write");
        public static final Supplier<class_3414> BSOD = SoundEvents.register("misc", "bsod");

        private static Supplier<class_3414> register(String category, String key) {
            Preconditions.checkState((category != null && !category.isEmpty() ? 1 : 0) != 0, (Object)"'category' should not be empty.");
            Preconditions.checkState((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"'key' should not be empty.");
            String path = category + "." + key;
            return Register.soundEvent(path, () -> class_3414.method_47908((class_2960)Exposure.resource(path)));
        }

        static void init() {
        }
    }

    public static class ArgumentTypes {
        public static final Supplier<class_2314<SizeMultiplierArgument, class_2319.class_7219>> EXPOSURE_SIZE = Register.commandArgumentType("exposure_size", SizeMultiplierArgument.class, class_2319.method_41999(SizeMultiplierArgument::new));
        public static final Supplier<class_2314<ExposureLookArgument, class_2319.class_7219>> EXPOSURE_LOOK = Register.commandArgumentType("exposure_look", ExposureLookArgument.class, class_2319.method_41999(ExposureLookArgument::new));
        public static final Supplier<class_2314<ShaderLocationArgument, class_2319.class_7219>> SHADER_LOCATION = Register.commandArgumentType("shader_location", ShaderLocationArgument.class, class_2319.method_41999(ShaderLocationArgument::new));
        public static final Supplier<class_2314<TextureLocationArgument, class_2319.class_7219>> TEXTURE_LOCATION = Register.commandArgumentType("texture_location", TextureLocationArgument.class, class_2319.method_41999(TextureLocationArgument::new));
        public static final Supplier<class_2314<ColorPaletteArgument, class_2319.class_7219>> COLOR_PALETTE_LOCATION = Register.commandArgumentType("color_palette_location", ColorPaletteArgument.class, class_2319.method_41999(ColorPaletteArgument::new));

        public static void init() {
        }
    }

    public static class Registries {
        public static final class_5321<class_2378<ColorPalette>> COLOR_PALETTE = class_5321.method_29180((class_2960)Exposure.resource("color_palette"));
        public static final class_5321<class_2378<Lens>> LENS = class_5321.method_29180((class_2960)Exposure.resource("lens"));
        public static final class_5321<class_2378<Filter>> FILTER = class_5321.method_29180((class_2960)Exposure.resource("filter"));
    }

    public static class Tags {

        public static class Blocks {
            public static final class_6862<class_2248> CHROMATIC_REFRACTORS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)Exposure.resource("chromatic_refractors"));
        }

        public static class Items {
            public static final class_6862<class_1792> FILM_ROLLS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("film_rolls"));
            public static final class_6862<class_1792> DEVELOPED_FILM_ROLLS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("developed_film_rolls"));
            public static final class_6862<class_1792> CYAN_PRINTING_DYES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("cyan_printing_dyes"));
            public static final class_6862<class_1792> MAGENTA_PRINTING_DYES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("magenta_printing_dyes"));
            public static final class_6862<class_1792> YELLOW_PRINTING_DYES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("yellow_printing_dyes"));
            public static final class_6862<class_1792> BLACK_PRINTING_DYES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("black_printing_dyes"));
            public static final class_6862<class_1792> PHOTO_PAPERS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("photo_papers"));
            public static final class_6862<class_1792> PHOTO_AGERS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("photo_agers"));
            public static final class_6862<class_1792> FLASHES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("flashes"));
            public static final class_6862<class_1792> LENSES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("lenses"));
            public static final class_6862<class_1792> FILTERS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("filters"));
            public static final class_6862<class_1792> RED_FILTERS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("red_filters"));
            public static final class_6862<class_1792> GREEN_FILTERS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("green_filters"));
            public static final class_6862<class_1792> BLUE_FILTERS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("blue_filters"));
        }
    }

    public static class LootTables {
        public static final class_5321<class_52> SIMPLE_DUNGEON_INJECT = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)Exposure.resource("chests/simple_dungeon"));
        public static final class_5321<class_52> ABANDONED_MINESHAFT_INJECT = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)Exposure.resource("chests/abandoned_mineshaft"));
        public static final class_5321<class_52> STRONGHOLD_CROSSING_INJECT = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)Exposure.resource("chests/stronghold"));
        public static final class_5321<class_52> VILLAGE_PLAINS_HOUSE_INJECT = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)Exposure.resource("chests/village_plains_house"));
        public static final class_5321<class_52> SHIPWRECK_MAP_INJECT = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)Exposure.resource("chests/shipwreck_map"));
    }

    public static class Stats {
        public static final Map<class_2960, class_3446> STATS = new HashMap<class_2960, class_3446>();
        public static final class_2960 INTERACT_WITH_LIGHTROOM = Stats.register(Exposure.resource("interact_with_lightroom"), class_3446.field_16975);
        public static final class_2960 FILM_FRAMES_EXPOSED = Stats.register(Exposure.resource("film_frames_exposed"), class_3446.field_16975);
        public static final class_2960 FLASHES_TRIGGERED = Stats.register(Exposure.resource("flashes_triggered"), class_3446.field_16975);

        private static class_2960 register(class_2960 location, class_3446 formatter) {
            STATS.put(location, formatter);
            return location;
        }

        public static void register() {
            STATS.forEach((location, formatter) -> {
                class_2378.method_10230((class_2378)class_7923.field_41183, (class_2960)location, (Object)location);
                class_3468.field_15419.method_14955(location, formatter);
            });
        }
    }
}

